<?php
// Require the initialisation file
/*Cron File to calculate Auto ecpm value
 *Manivasaki
 *date:18 may 2017
 */


$path = dirname(__FILE__);
require_once $path . '/../../init.php';
date_default_timezone_set('UTC');
function OX_Delivery_logMessage($message, $priority = 6) 
{
    $conf = $GLOBALS['_MAX']['CONF'];
    if (empty($conf['deliveryLog']['enabled'])) return true;
    $priorityLevel = is_numeric($conf['deliveryLog']['priority']) ? $conf['deliveryLog']['priority'] : 6;
	if ($priority > $priorityLevel && empty($_REQUEST[$conf['var']['trace']])) {
        return true;
    }
    error_log('[' . date('r') . "] {$conf['log']['ident']}-delivery-{$GLOBALS['_MAX']['thread_id']}: {$message}\n", 3, MAX_PATH . '/var/' . $conf['deliveryLog']['name']);
    OX_Delivery_Common_hook('logMessage', array(
        $message,
        $priority
    ));
    return true;
}

function OX_Delivery_Common_hook($hookName, $aParams = array(), $functionName = '')
{
    $return = null;
	if (!empty($functionName)) {
        $aParts = explode(':', $functionName);
		if (count($aParts) === 3) {
            $functionName = OX_Delivery_Common_getFunctionFromComponentIdentifier($functionName, $hookName);
        }
		if (function_exists($functionName)) {
            $return = call_user_func_array($functionName, $aParams);
        }
	} else {
		if (!empty($GLOBALS['_MAX']['CONF']['deliveryHooks'][$hookName])) {
            $return = array();
            $hooks = explode('|', $GLOBALS['_MAX']['CONF']['deliveryHooks'][$hookName]);
			foreach ($hooks as $identifier) {
                $functionName = OX_Delivery_Common_getFunctionFromComponentIdentifier($identifier, $hookName);
				if (function_exists($functionName)) {
                    OX_Delivery_logMessage('calling on ' . $functionName, 7);
                    $return[$identifier] = call_user_func_array($functionName, $aParams);
                }
            }
        }
    }
    return $return;
}

function OX_Delivery_Common_getFunctionFromComponentIdentifier($identifier, $hook = null)
{
    $aInfo = explode(':', $identifier);
    $functionName = 'Plugin_' . implode('_', $aInfo) . '_Delivery' . (!empty($hook) ? '_' . $hook : '');
	if (!function_exists($functionName)) {
        if (!empty($GLOBALS['_MAX']['CONF']['pluginSettings']['useMergedFunctions'])) _includeDeliveryPluginFile('/var/cache/' . OX_getHostName() . '_mergedDeliveryFunctions.php');
		if (!function_exists($functionName)) {
            _includeDeliveryPluginFile($GLOBALS['_MAX']['CONF']['pluginPaths']['plugins'] . '/' . implode('/', $aInfo) . '.delivery.php');
			if (!function_exists($functionName)) {
                _includeDeliveryPluginFile('/lib/OX/Extension/' . $aInfo[0] . '/' . $aInfo[0] . 'Delivery.php');
                $functionName = 'Plugin_' . $aInfo[0] . '_delivery';
				if (!empty($hook) && function_exists($functionName . '_' . $hook)) {
					$functionName .= '_' . $hook;
                }
            }
        }
    }
    return $functionName;
}

function _includeDeliveryPluginFile($fileName)
{
	if (!in_array($fileName, array_keys($GLOBALS['_MAX']['FILES']))) {
        $GLOBALS['_MAX']['FILES'][$fileName] = true;
		if (file_exists(MAX_PATH . $fileName)) {
            include MAX_PATH . $fileName;
        }
    }
}

function MAX_Dal_Delivery_Include()
{
    static $included;
	if (isset($included)) {
        return;
    }
    $included = true;
    $conf = $GLOBALS['_MAX']['CONF'];
	if (isset($conf['origin']['type']) && is_readable(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php')) {
		require(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php');
	} else {
		require(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['database']['type']) . '.php');
	}
}
MAX_Dal_Delivery_Include();
if (!empty($conf['debug']['production'])) {
	error_reporting(E_ALL & ~(E_NOTICE | E_WARNING | E_DEPRECATED | E_STRICT));
} else {
	error_reporting(E_ALL & ~(E_DEPRECATED | E_STRICT));
}
//Setting up for unlimited time.
set_time_limit(0);

//delete vast_xml file 
//$uri = str_replace("ads/www/admin","vast_xml/*",$path);

$site = explode("/www/admin", $path);
$vast_path = $site[0].'/www/vast_xml/*';
$uri = $vast_path;
$file_name = glob($uri);


	foreach($file_name as $file)
	{ 
	  if(is_file($file))
	  {
		 $create_date =  strtotime(date("Y-m-d H:i:s",filemtime($file))); 
		 $date = strtotime(date("Y-m-d H:i:s",strtotime('-1 hours')));
		if($create_date < $date)
		{
			unlink($file); // delete file
		}
	  }
	   
	} 
//delete vast_xml file 
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
$dsp_query = OA_Dal_Delivery_query("SELECT id,weight,ecpm_duration FROM ".$table_prefix."djax_video_adnetwork WHERE auto_ecpm = 1  AND status = 1");

if(OA_Dal_Delivery_numRows($dsp_query) > 0) 
{
	
while ($fetch_dsp = OA_Dal_Delivery_fetchAssoc($dsp_query)) {
//print_r($fetch_dsp);
$current_date = date('Y-m-d');

if($fetch_dsp['ecpm_duration'] == 1)
{
$start_date = date('Y-m-d 00:00:00', strtotime('- 1 days'));
$end_date = date('Y-m-d 23:59:59');		
}
elseif($fetch_dsp['ecpm_duration'] == 2)
{
$start_date = date('Y-m-d 00:00:00', strtotime('- 7 days'));
$end_date = date('Y-m-d 23:59:59');	
}
else
{
$start_date = date('Y-m-d 00:00:00', strtotime('-1 month'));
$end_date = date('Y-m-d 23:59:59');			
}


$time = strtotime($end_date) - strtotime($start_date);
$time_dur = round($time / (60 * 60 * 24));
		
$ecpm_query = OA_Dal_Delivery_query("SELECT IFNULL((((SUM(oxah.total_revenue)/SUM(oxah.impressions))*1000)),0) as ECPM FROM ".$table_prefix."djax_video_adnetwork as dva 
				join ".$table_prefix."banners as oxb on dva.id=oxb.exchange_id join ".$table_prefix."djax_geographical_stats as oxah on oxah.ad_id=oxb.bannerid WHERE dva.id = ".$fetch_dsp['id']." AND oxb.exchange_id = ".$fetch_dsp['id']." AND oxah.date_time BETWEEN '".$start_date."' AND '".$end_date."'");
				
						
if(OA_Dal_Delivery_numRows($ecpm_query) > 0) 
{
	
$ecpm_fetch = OA_Dal_Delivery_fetchAssoc($ecpm_query);	

if($ecpm_fetch['ECPM'] > 0)
{
$ecmp_val = ($ecpm_fetch['ECPM']/$time_dur);	
OA_Dal_Delivery_query("UPDATE ".$table_prefix."djax_video_adnetwork SET ecpm = '".$ecmp_val."' WHERE id = ".$fetch_dsp['id']."");	


}
	
}				
					
if($fetch_dsp['weight'] == 1)
{

$select_country = OA_Dal_Delivery_query("SELECT distinct country_code FROM ".$table_prefix."djax_video_country_weight WHERE id = ".$fetch_dsp['id'].""); 

if(OA_Dal_Delivery_numRows($select_country) > 0) 
{
	
while ($fetch_country = OA_Dal_Delivery_fetchAssoc($select_country)) 
{
	
	
	
	 //~ echo "SELECT sum(oxah.ecpm) as ecpms FROM  
//~ ".$table_prefix."djax_video_adnetwork as dva 
				//~ JOIN ".$table_prefix."djax_dsp_country_weight as dw on dw.dsp_id = dva.id AND dw.country_code = '".$fetch_country['country_code']."'
				//~ JOIN ".$table_prefix."banners as oxb on dva.id=oxb.exchange_id 
				//~ JOIN ".$table_prefix."djax_geographical_stats as oxah on oxah.ad_id=oxb.bannerid AND oxah.country_code = dw.country_code
				 //~ AND oxah.country_code = '".$fetch_country['country_code']."'
				//~ WHERE dva.id = ".$fetch_dsp['id']." AND oxb.exchange_id = ".$fetch_dsp['id']." AND oxah.date_time BETWEEN '".$start_date."' AND '".$end_date."'"; die("iyu");
	
	
	
$select_geo =  OA_Dal_Delivery_query("SELECT sum(oxah.ecpm) as ecpms FROM  
".$table_prefix."djax_video_adnetwork as dva 
				join ".$table_prefix."djax_dsp_country_weight as dw on dw.dsp_id = dva.id AND dw.country_code = '".$fetch_country['country_code']."'
				join ".$table_prefix."banners as oxb on dva.id=oxb.exchange_id 
				join ".$table_prefix."djax_geographical_stats as oxah on oxah.ad_id=oxb.bannerid AND oxah.country_code = dw.country_code
				 AND oxah.country_code = '".$fetch_country['country_code']."'
				WHERE dva.id = ".$fetch_dsp['id']." AND oxb.exchange_id = ".$fetch_dsp['id']." AND oxah.date_time BETWEEN '".$start_date."' AND '".$end_date."'");
				
				
if(OA_Dal_Delivery_numRows($select_geo) > 0) 
{
$fetch_geo = OA_Dal_Delivery_fetchAssoc($select_geo);
if($fetch_geo['ecpms'] > 0)
{	
$ecmp_geo = ($fetch_geo['ecpms']/$time_dur);	
OA_Dal_Delivery_query("UPDATE ".$table_prefix."djax_video_country_weight SET country_weight=".$ecmp_geo." WHERE dsp_id = ".$fetch_dsp['id']." AND country_code = '".$fetch_country['country_code']."'");
}
}				
}//die("asjhj");
}	
}
}
//die("welcome");
}
?>
